VERSION 5.00
Object = "{648A5603-2C6E-101B-82B6-000000000014}#1.1#0"; "MSCOMM32.OCX"
Begin VB.Form Form1 
   BorderStyle     =   1  'Œ()
   Caption         =   "SR-430 Sample Program-1"
   ClientHeight    =   4530
   ClientLeft      =   45
   ClientTop       =   435
   ClientWidth     =   6255
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   4530
   ScaleWidth      =   6255
   StartUpPosition =   3  'Windows ̊l
   Begin MSCommLib.MSComm MSComm1 
      Left            =   240
      Top             =   3720
      _ExtentX        =   1005
      _ExtentY        =   1005
      _Version        =   393216
      DTREnable       =   -1  'True
   End
   Begin VB.CommandButton Command1 
      Caption         =   "OMR Read"
      Height          =   615
      Left            =   1500
      TabIndex        =   1
      Top             =   3720
      Width           =   3255
   End
   Begin VB.TextBox Text1 
      Height          =   3135
      Left            =   240
      MultiLine       =   -1  'True
      ScrollBars      =   3  '
      TabIndex        =   0
      Top             =   120
      Width           =   5775
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False

Private Sub Command1_Click()
    Dim Response    As String
    Dim TMCount     As String
    Dim CMode       As String
    Dim EMode()     As String
    Dim ReciveCnt   As String
    
' >>>>> Check device communication <<<<<
    If MSComm1.DSRHolding = False Then              'Check communication.
        MsgBox "The device is not turned on" + Chr(&HD) + _
               "or no communications cable is connected. !!", 16, "SR-430 Sample Program-1"
        Screen.MousePointer = 0
        Exit Sub
    End If
    If MSComm1.CTSHolding = False Then              'Check device communication state.
        MsgBox "The device is not in the receivable state.!!", 16, "SR-430 Sample Program-1"
        Screen.MousePointer = 0
        Exit Sub
    End If

' >>>>> lnitialize <<<<<
    MSComm1.Output = Chr(&H18) + Chr(&HD)           'Send initialize command.
    Do                                              'Wait until 1byte is received.
        DoEvents
    Loop Until MSComm1.InBufferCount = 1
    Response = MSComm1.Input                        'Receive initialize responce.
    If Response <> Chr(&H6) Then
        MsgBox "Initialization fails !!"
        Screen.MousePointer = 0
        Exit Sub
    End If
    
    MSComm1.Output = Chr(&H13) + "12" + Chr(&HD)    'Send read line specify command (12 lines.)
    
    MSComm1.Output = Chr(&H10) + "T" + Chr(&HD)     'Send timing format specify command(direct-under type)
    
    MSComm1.Output = Chr(&H2) + "2" + Chr(&HD)
    
' >>>>> Read card <<<<<
    MSComm1.Output = "?" + Chr(&HD)                 'Send card read command.
    ReciveCnt = 1                                   'Set number of bytes of read status to receive.
    Do                                              'Wait until read status is received.
        DoEvents
    Loop Until MSComm1.InBufferCount = ReciveCnt
    Response = MSComm1.Input                        'Receive read status.
    If Response <> "0" Then                         'Check read status.
        MsgBox "Error occurs!!" + Chr(&HD) + _
               "Read Status = " + Response
        Screen.MousePointer = 0
        Exit Sub
    End If
    
' >>>>> Read timing mark count <<<<<
    MSComm1.Output = Chr(&H5) + "T" + Chr(&HD)      'Send timing mark count read command.
    ReciveCnt = 1                                   'Wait until timing mark count is received.
    Do
        DoEvents
    Loop Until MSComm1.InBufferCount = 3
    TMCount = MSComm1.Input                         'Receive timing mark count.
    Text1.Text = "Timing mark count : " + TMCount + Chr(&HD) + Chr(&HA)
                                                    'Display timing mark count.

' >>>>> Read C mode (read fixed length data) <<<<<
    MSComm1.Output = Chr(&H10) + "C001" + TMCount + Chr(&HD)
                                                    'Send C mode read command.
    Do                                              'Wait until C mode data is received.
        DoEvents
    Loop Until MSComm1.InBufferCount = 3 * Val(TMCount)
                                                    'Keep looping until "3*timing mark count" is received
                                                    'since one column corresponds to 3 bytes.
    CMode = MSComm1.Input                           'Receive C mode data.
    Text1.Text = Text1.Text + "C Mode   : " + CMode + Chr(&HD) + Chr(&HA)
                                                    'Display C mode data.
    
' >>>>> Read E mode (read variable length data) <<<<<
    ReDim EMode(Val(TMCount)) As String             'Secure area
    Dim DataLength As Integer
    
    Text1.Text = Text1.Text + "E Mode   : " + Chr(&HD) + Chr(&HA)
        
    MSComm1.Output = Chr(&H10) + "E001" + TMCount + Chr(&HD)
                                                    'Send E mode read command.
    ReciveCnt = 0
    Response = ""
    Do                                              'Wait until E mode data is received.
        DoEvents
        Response = Response + MSComm1.Input         'Receive E mode data.
        DataLength = InStr(Response, Chr(&HD))      'Extract received data for each column.
        If DataLength <> 0 Then
            EMode(ReciveCnt) = Left(Response, DataLength)
            Text1.Text = Text1.Text + Format(ReciveCnt + 1, "000") + _
                        "-Column : " + EMode(ReciveCnt) + Chr(&HA)
            Response = Mid(Response, DataLength + 1)
            ReciveCnt = ReciveCnt + 1
        End If
    Loop Until reciveCount = Val(TMCount)
    Screen.MousePointer = 0                         'Initialize mouse polnter.
End Sub

Private Sub Form_Load()
    Screen.MousePointer = 11                        'Change mouse pointer to Sandglass
    
' >>>>> Initialize communication line <<<<<
    MSComm1.Handshaking = comRTS                    'Set handshake method (RS-CS control)
    MSComm1.RTSEnable = True                        'RS signal = High (receivable)
    MSComm1.CommPort = 4                            'Set communication port (COM4).
    MSComm1.Settings = "38400,n,7,2"                'Set communication conditions.
    MSComm1.PortOpen = True                         'Open communication line.
    MSComm1.InBufferCount = 0                       'Clear receive buffer.
    MSComm1.OutBufferCount = 0                      'Clear Sendbuffer.
    
    Screen.MousePointer = 0                         'Initialize mouse pointer.
End Sub

Private Sub Form_Unload(Cancel As Integer)
    MSComm1.PortOpen = False                        'Close communication line.
    End                                             'Finish program.
End Sub

